import { withBemMod } from '@bem-react/core';
import { cnIcon } from '@yandex-lego/components/Icon';

import './Icon_type_driverLicense.css';

export interface IWithTypeDriverLicenseProps {
  /**
   * Тип иконки.
   */
  type?: 'driverLicense';
}

export interface IWithTypeDriverLicenseInactiveProps {
  type?: 'driverLicense_inactive';
}

/**
 * Модификатор, отвечающий за тип иконки.
 */
export const withTypeDriverLicense = withBemMod<IWithTypeDriverLicenseProps>(cnIcon(), {
  type: 'driverLicense',
});

export const withTypeDriverLicenseInactive = withBemMod<IWithTypeDriverLicenseInactiveProps>(
  cnIcon(),
  { type: 'driverLicense_inactive' },
);
