import { withBemMod } from '@bem-react/core';
import { cnIcon } from '@yandex-lego/components/Icon';

import './Icon_type_oms.css';

export interface IWithTypeOmsProps {
  /**
   * Тип иконки.
   */
  type?: 'oms';
}

export interface IWithTypeOmsInactiveProps {
  type?: 'oms_inactive';
}

/**
 * Модификатор, отвечающий за тип иконки.
 */
export const withTypeOms = withBemMod<IWithTypeOmsProps>(cnIcon(), { type: 'oms' });

export const withTypeOmsInactive = withBemMod<IWithTypeOmsInactiveProps>(cnIcon(), {
  type: 'oms_inactive',
});
