import { withBemMod } from '@bem-react/core';
import { cnIcon } from '@yandex-lego/components/Icon';

import './Icon_type_passport.css';

export interface IWithTypePassportProps {
  /**
   * Тип иконки.
   */
  type?: 'passport';
}

export interface IWithTypePassportInactiveProps {
  type?: 'passport_inactive';
}

/**
 * Модификатор, отвечающий за тип иконки.
 */
export const withTypePassport = withBemMod<IWithTypePassportProps>(cnIcon(), { type: 'passport' });

export const withTypePassportInactive = withBemMod<IWithTypePassportInactiveProps>(cnIcon(), {
  type: 'passport_inactive',
});
