import { withBemMod } from '@bem-react/core';
import { cnIcon } from '@yandex-lego/components/Icon';

import './Icon_type_snils.css';

export interface IWithTypeSnilsProps {
  /**
   * Тип иконки.
   */
  type?: 'snils';
}

export interface IWithTypeSnilsInactiveProps {
  type?: 'snils_inactive';
}

/**
 * Модификатор, отвечающий за тип иконки.
 */
export const withTypeSnils = withBemMod<IWithTypeSnilsProps>(cnIcon(), { type: 'snils' });

export const withTypeSnilsInactive = withBemMod<IWithTypeSnilsProps>(cnIcon(), {
  type: 'snils_inactive',
});
