import React from 'react';

export interface IPageLinkProps {
  to?: string;
  blank?: boolean;
  href?: string;
  className?: string;
  as?: React.ReactType;
}

export const PageLink: React.FC<IPageLinkProps> = ({
  to,
  href,
  children,
  className,
  blank,
  as,
}) => {
  if (href || !as) {
    return (
      <a
        className={className}
        href={href || href}
        {...(blank ? { target: '_blank', rel: 'noopener' } : {})}
      >
        {children}
      </a>
    );
  }

  const Component = as;

  return (
    <Component className={className} to={to}>
      {children}
    </Component>
  );
};
