import React, { ReactElement } from 'react';

import { Meta, Story } from '@storybook/react';

import { List } from '.';
import { Divider } from '../Divider/Divider';
import { Document } from '../Document';
import { ListGroups } from '../ListGroups';
import { IListGroupsProps } from '../ListGroups/ListGroups.interface';
import { ListItem } from '../ListItem/ListItem';
import { IListProps } from './List.interface';

export default {
  id: 'List',
  title: 'Components/List',
  component: List,
} as Meta;

const renderListItem = (): ReactElement<IListGroupsProps> => {
  const header = <Divider color="#e6e9f0" />;

  return (
    <ListGroups
      items={[
        <ListItem key={0}>
          <Document data={{ id: 'driverLicense', title: 'Паспорт РФ', isActive: true }} />
        </ListItem>,
        <ListItem key={1} header={header}>
          <Document data={{ id: 'driverLicense', title: 'Паспорт РФ', isActive: false }} />
        </ListItem>,
      ]}
    />
  );
};

const Template: Story<IListProps> = (args) => (
  <div style={{ width: '360px' }}>
    <List {...args} groups={renderListItem()} />
  </div>
);

export const Default = Template.bind({});

Default.args = {};
