import React from 'react';

import { cn } from '@bem-react/classname';

import { IListItemProps } from './ListItem.interface';

import './ListItem.css';

const cnListItem = cn('ListItem');

export const ListItem: React.FC<IListItemProps> = ({ className, header, footer, children }) => {
  return (
    <div className={cnListItem(null, [className])}>
      {header}
      {children}
      {footer}
    </div>
  );
};
