import React, { FC, HTMLAttributes } from 'react';

import { cnListItemView } from '../constants';

import './ListItemViewSlot.css';

export interface ListItemViewSlotProps extends HTMLAttributes<HTMLDivElement> {
  alignItems?: 'top' | 'center';
}

export const ListItemViewSlot: FC<ListItemViewSlotProps> = (props) => {
  const { className, alignItems, children, ...otherProps } = props;

  return (
    <div
      className={cnListItemView('Slot', null, [className])}
      {...otherProps}
      data-align={alignItems}
    >
      {children}
    </div>
  );
};
