import React, { FC } from 'react';

import { ArgTypes, Story } from '@storybook/react';
import { Icon, ListItemView, Text } from '@yandex-id/components';

const IconWrapper: FC = (props) => {
  const { children } = props;
  const style = {
    width: '24px',
    height: '24px',
    display: 'inline-flex',
    justifyContent: 'center',
    alignItems: 'center',
  };

  return <div style={style}>{children}</div>;
};

interface DefaultArgs {
  interactive?: boolean;
  alignItems?: 'top' | 'center';
  alignItemsBefore?: 'top' | 'center';
  alignItemsContent?: 'top' | 'center';
  alignItemsAfter?: 'top' | 'center';
  before?: 'none' | 'passport' | 'oms' | 'snils' | 'inn';
  after?: 'none' | 'arrowRight';
  content?: string;
  height?: string | number;
  width?: string | number;
}

export const Default: Story<DefaultArgs> = (args) => {
  const {
    alignItems = 'top',
    interactive,
    alignItemsBefore,
    alignItemsContent,
    alignItemsAfter,
    content,
    before = 'passport',
    after = 'arrowRight',
    height,
    width,
  } = args;

  return (
    <ListItemView
      alignItems={alignItems}
      interactive={interactive}
      style={{ height, width }}
      data-testid="root"
    >
      {before !== 'none' && (
        <ListItemView.Before alignItems={alignItemsBefore} data-testid="before">
          <Icon type={before} />
        </ListItemView.Before>
      )}

      <ListItemView.Content alignItems={alignItemsContent} data-testid="content">
        <Text variant="text-m" color="primary">
          {content}
        </Text>
      </ListItemView.Content>

      {after !== 'none' && (
        <ListItemView.After alignItems={alignItemsAfter} data-testid="after">
          <IconWrapper>
            <Icon type={after} />
          </IconWrapper>
        </ListItemView.After>
      )}
    </ListItemView>
  );
};

const alignItemsControl: ArgTypes[string] = {
  control: { type: 'select' },
  options: ['top', 'center'],
};

Default.args = {
  alignItems: 'top',
  before: 'passport',
  content: 'Паспорт',
  after: 'arrowRight',
  interactive: true,
};

Default.argTypes = {
  alignItems: alignItemsControl,
  alignItemsBefore: alignItemsControl,
  alignItemsContent: alignItemsControl,
  alignItemsAfter: alignItemsControl,
  before: {
    control: { type: 'select' },
    options: ['none', 'passport', 'inn', 'snils', 'oms'],
  },
  content: {
    control: { type: 'text' },
  },
  after: {
    control: { type: 'select' },
    options: ['none', 'arrowRight'],
  },
  height: {
    control: { type: 'text' },
    table: { disable: true },
  },
  width: {
    control: { type: 'text' },
    table: { disable: true },
  },
};
