import React from 'react';

import { cn } from '@bem-react/classname';

import { PageLink } from '../Link';
import { PageHeaderLogoId } from './Id';
import { PageHeaderLogoYandexEn } from './YandexEn';
import { PageHeaderLogoYandexRu } from './YandexRu';

import './Logo.css';

const b = cn('PageHeaderLogo');

interface IPageHeaderLogoProps {
  passportHost?: string;
  tld: string;
  lang: string;
  isProfile?: boolean;
  linkComponent?: React.ReactType;
}

export const PageHeaderLogo: React.FC<IPageHeaderLogoProps> = ({
  tld,
  lang,
  isProfile,
  linkComponent,
  passportHost = `passport.yandex.${tld}`,
}) => {
  const isRu = ['ru', 'uk'].includes(lang);

  return (
    <div className={b()}>
      <a href={`//yandex.${tld}`} className={b('yandex', { ru: isRu, en: !isRu })}>
        {isRu ? <PageHeaderLogoYandexRu /> : <PageHeaderLogoYandexEn />}
      </a>
      <PageLink
        to={isProfile ? '/profile' : undefined}
        href={isProfile ? undefined : `//${passportHost}/profile`}
        className={b('id')}
        as={linkComponent}
      >
        <PageHeaderLogoId />
      </PageLink>
    </div>
  );
};
