import React from 'react';

import { cn } from '@bem-react/classname';

import { useQueryFeatureFlags } from '../../libs/feature-flags';
import { INavLink } from '../../types';
import { PageHeader } from '../Header';
import { HeaderSuggest } from '../HeaderSuggest';
import { PageNavigation } from '../Navigation';

import './Page.css';

const b = cn('Page');

export interface IPageProps {
  pathname: string;
  passportHost?: string;
  tld: string;
  lang: string;
  isProfile?: boolean;
  isHeaderHidden?: boolean;
  plus?: React.ReactNode;
  user?: React.ReactNode;
  navigationLinks: INavLink[];
  otherNavigationLinks?: INavLink[];
  specialNavigationLinks?: INavLink[];
  linkComponent?: React.ReactType;
}

export const Page: React.FC<IPageProps> = ({
  tld,
  lang,
  pathname,
  children,
  passportHost,
  isProfile,
  isHeaderHidden,
  navigationLinks,
  specialNavigationLinks,
  otherNavigationLinks,
  linkComponent,
  plus,
  user,
}) => {
  const features = useQueryFeatureFlags();

  const hasNav = Boolean(navigationLinks);
  const isSuggestEndabled = features.isEnabled('suggest');

  return (
    <div className={b()}>
      {!isHeaderHidden && (
        <div className={b('header', { margin: hasNav })}>
          <PageHeader
            lang={lang}
            passportHost={passportHost}
            isProfile={isProfile}
            tld={tld}
            linkComponent={linkComponent}
            plus={plus}
            user={user}
          >
            {isSuggestEndabled && (
              <PageHeader.Suggest>
                <HeaderSuggest />
              </PageHeader.Suggest>
            )}
          </PageHeader>
        </div>
      )}
      {navigationLinks && (
        <>
          <div className={b('nav')}>
            <PageNavigation
              navigationLinks={navigationLinks}
              specialNavigationLinks={specialNavigationLinks}
              pathname={pathname}
              linkComponent={linkComponent}
            />
          </div>
          {isSuggestEndabled && (
            <div className={b('Search')}>
              <HeaderSuggest scale="large" layout="fullscreen" />
            </div>
          )}
        </>
      )}
      <div className={b('content', { hasNav })}>
        {(navigationLinks || specialNavigationLinks || otherNavigationLinks) && (
          <aside className={b('aside')}>
            <PageNavigation
              aside
              pathname={pathname}
              linkComponent={linkComponent}
              navigationLinks={navigationLinks}
              specialNavigationLinks={specialNavigationLinks}
              otherNavigationLinks={otherNavigationLinks}
            />
          </aside>
        )}
        <main className={b('main')}>
          <div className={b('mainInner')}>{children}</div>
        </main>
      </div>
    </div>
  );
};
