import React, { useState } from 'react';

import { Meta, Story } from '@storybook/react';

import { IPopupProps, Popup } from '.';
import { Button } from '../Button';
import { Divider } from '../Divider/Divider';
import { Document } from '../Document';
import { Icon } from '../Icon';
import { List } from '../List';
import { ListGroups } from '../ListGroups/ListGroups';
import { ListItem } from '../ListItem/ListItem';

export default {
  id: 'Popup',
  title: 'Components/Popup',
  component: Popup,
} as Meta;

const renderDrawerItem = (): JSX.Element[] => {
  const header = <Divider />;

  return [
    <ListItem key={0}>
      <Document
        data={{ id: 'driverLicense', title: 'Водительское удостоверение', isActive: false }}
      />
    </ListItem>,
    <ListItem key={1} header={header}>
      <Document data={{ id: 'passport', title: 'Паспорт РФ', isActive: true }} />
    </ListItem>,
  ];
};

const Template: Story<IPopupProps> = () => {
  const scopeRef = React.useRef<HTMLDivElement>(null);
  const anchorRef = React.useRef(null);
  const [isVisible, setVisible] = useState(false);

  return (
    <div style={{ width: '360px' }} ref={scopeRef}>
      <Button
        view="default"
        pin="circle-circle"
        size="l"
        innerRef={anchorRef}
        icon={(className) => <Icon className={className} glyph="addDocument" />}
        onClick={() => setVisible(!isVisible)}
      >
        Добавить
      </Button>
      <Popup
        className="Popup_storybook"
        view="default"
        target="anchor"
        anchor={anchorRef}
        visible={isVisible}
        scope={scopeRef}
        onClose={() => setVisible(false)}
      >
        <List
          header={<div className="MainList">Добавить документ</div>}
          groups={[
            <ListGroups
              key={0}
              header={<div className="Group1">Удостоверения личности</div>}
              items={renderDrawerItem()}
            />,
            <ListGroups
              key={1}
              header={<div className="Group2">Госуслуги</div>}
              items={[...renderDrawerItem(), ...renderDrawerItem(), ...renderDrawerItem()]}
            />,
          ]}
        />
      </Popup>
    </div>
  );
};

export const Default = Template.bind({});

Default.args = {};
