import { compose } from '@bem-react/core';
import {
  IPopupNonvisualProps,
  IPopupProps as IPopupPropsBase,
  IPopupTargetAnchorProps,
  IPopupViewDefaultProps,
  Popup as PopupBase,
  cnPopup,
  withNonvisual,
  withTargetAnchor,
  withViewDefault,
} from '@yandex-lego/components/Popup/desktop';
import { IWithZIndexProps, withZIndex } from '@yandex-lego/components/withZIndex';

const Popup = compose(withZIndex, withNonvisual, withTargetAnchor, withViewDefault)(PopupBase);

type IPopupProps = IPopupPropsBase &
  IPopupNonvisualProps &
  IWithZIndexProps &
  IPopupTargetAnchorProps &
  IPopupViewDefaultProps;

export { Popup, IPopupProps, cnPopup };
