import React from 'react';

import { Story } from '@storybook/react';
import { ProgressCircle, ProgressCircleProps } from '@yandex-id/components';

export const Default: Story<ProgressCircleProps> = (args) => {
  return <ProgressCircle {...args} data-testid="element" />;
};

Default.args = {
  indeterminate: false,
  min: 0,
  max: 100,
  value: 35,
  variant: 'default',
  size: 24,
  strokeWidth: 2,
  strokeLinecap: 'round',
  clockwise: true,
};

Default.argTypes = {
  variant: {
    control: { type: 'select' },
    options: ['default', 'brand'],
  },
  size: {
    control: { type: 'select' },
    options: [16, 24, 32, 36, 44],
  },
  formatStyle: {
    control: { type: 'select' },
    options: ['percent', 'decimal'],
  },
  min: {
    control: { type: 'range', min: 0, max: 100, step: 1 },
  },
  max: {
    control: { type: 'range', min: 0, max: 100, step: 1 },
  },
  value: {
    control: { type: 'range', min: 0, max: 100, step: 1 },
  },
  strokeWidth: {
    control: { type: 'range', min: 1, max: 22, step: 1 },
  },
  strokeLinecap: {
    control: { type: 'select' },
    options: ['round', 'butt'],
  },
};
