import React from 'react';

import { Story } from '@storybook/react';
import { ProgressCircle } from '@yandex-id/components';

function getColor(value: number, min = 0, max = 100) {
  return Math.min(Math.max(Math.floor((4 * (value - min)) / (max - min)), 0), 3) * 25;
}

const styles = `
[data-variant][data-color='0'] {
  --id-progress-circle-dash-color: var(--id-color-decor-red-800);
}

[data-variant][data-color='25'] {
  --id-progress-circle-dash-color: var(--id-color-decor-orange-1000);
}

[data-variant][data-color='50'] {
  --id-progress-circle-dash-color: var(--id-color-decor-yellow-900);
}

[data-variant][data-color='100'] {
  --id-progress-circle-dash-color: var(--id-color-decor-green-1000);
}
`;

interface DynamicColorArgs {
  value: number;
}

export const DynamicColor: Story<DynamicColorArgs> = (args) => {
  return (
    <>
      <style>{styles}</style>
      <ProgressCircle
        variant="default"
        formatStyle="percent"
        value={args.value}
        size={44}
        strokeWidth={3}
        data-color={getColor(args.value)}
        data-testid="element"
      />
    </>
  );
};

DynamicColor.args = {
  value: 63,
};

DynamicColor.argTypes = {
  value: {
    control: { type: 'range', min: 0, max: 100, step: 1 },
  },
};
