import React from 'react';

import { Story } from '@storybook/react';
import { ProgressCircle } from '@yandex-id/components';

const styles = `
[data-variant][data-gradient]{
  --id-progress-circle-dash-color: url(#gradient-uniq-id);
}
`;

interface GradientArgs {
  value: number;
}

export const Gradient: Story<GradientArgs> = (args) => {
  return (
    <>
      <style>{styles}</style>
      <svg width="0" height="0">
        <defs>
          <linearGradient id="gradient-uniq-id" gradientTransform="rotate(90)">
            <stop offset="0" stopColor="#22AE55" />
            <stop offset="1" stopColor="#67C43B" />
          </linearGradient>
        </defs>
      </svg>

      <ProgressCircle
        variant="default"
        formatStyle="percent"
        value={args.value}
        size={44}
        strokeWidth={3}
        data-gradient
        data-testid="element"
      />
    </>
  );
};

Gradient.args = {
  value: 100,
};

Gradient.argTypes = {
  value: {
    control: { type: 'range', min: 0, max: 100, step: 1 },
  },
};
