export function makeCirclePath(cx: number, cy: number, radius: number, clockwise: boolean) {
  const rotation = clockwise ? 1 : 0;

  return [
    `M ${cx} ${cy}`,
    `m 0 ${-radius}`,
    `a ${radius} ${radius} ${rotation} 1 1 0 ${2 * radius}`,
    `a ${radius} ${radius} ${rotation} 1 1 0 -${2 * radius}`,
  ].join(' ');
}

export function clamp(value: number, min: number, max: number) {
  return Math.min(Math.max(value, min), max);
}

function calcRadius(size: number, strokeWidth: number) {
  return (size - strokeWidth) / 2;
}

export function calcStrokeWidth(baseRadius: number, size: number, strokeWidth: number) {
  const radius = calcRadius(size, strokeWidth);
  const ratio = baseRadius / radius;

  return ratio * clamp(strokeWidth, 0, radius * 2);
}

export function calcPercentage(value: number, min: number, max: number) {
  return (value - min) / (max - min);
}

export function calcDashOffset(circumferens: number, percentage: number, clockwise?: boolean) {
  const dashOffset = circumferens * (1 - percentage);

  return clockwise ? dashOffset : -dashOffset;
}
