/// <reference types='hermione' />

describe('PromoContent', function () {
  const elements = {
    component: '.PromoContent',
  };

  it('Default', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'default');
    await browser.assertView('default', elements.component);
  });

  it('Description', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'description');
    await browser.assertView('default', elements.component);
  });

  it('Image', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'image');
    await browser.assertView('default', elements.component);
  });

  it('Supertitle', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'supertitle');
    await browser.assertView('default', elements.component);
  });

  it('Secondary button', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'secondary-button');
    await browser.assertView('default', elements.component);
  });

  it('Additional control', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'control');
    await browser.assertView('default', elements.component);
  });

  it('Custom control margin', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'custom-control-margin');
    await browser.assertView('default', elements.component);
  });

  it('Center alignment', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'alignment');
    await browser.assertView('default', elements.component);
  });

  it('start alignment', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'alignment', { args: 'align:start' });
    await browser.assertView('default', elements.component);
  });

  it('start alignment, control center alignment', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'alignment', {
      args: 'align:start;controlAlign:center',
    });
    await browser.assertView('default', elements.component);
  });

  it('Center alignment, control start alignment', async function () {
    const { browser } = this;

    await browser.yaOpenStory('promocontent', 'alignment', {
      args: 'align:center;controlAlign:start',
    });
    await browser.assertView('default', elements.component);
  });
});
