import React from 'react';

import { Story } from '@storybook/react';

import { Button } from '../../Button';
import { PromoContent, PromoContentProps } from '../PromoContent';

type Args = Pick<PromoContentProps, 'align'> & {
  controlAlign?: 'start' | 'center';
};

export const Alignment: Story<Args> = (props: Args) => {
  return (
    <PromoContent align={props.align}>
      <PromoContent.Supertitle>Some kind of supertitle</PromoContent.Supertitle>
      <PromoContent.Title>Title</PromoContent.Title>
      <PromoContent.Description>Here goes some description</PromoContent.Description>
      <PromoContent.Control align={props.controlAlign}>
        <Button size="l">Optional control</Button>
      </PromoContent.Control>
      <PromoContent.Button>
        <Button width="max" size="l" view="action" pin="circle-circle">
          Press me!
        </Button>
      </PromoContent.Button>
    </PromoContent>
  );
};

Alignment.args = {
  align: 'center',
};

Alignment.argTypes = {
  align: {
    control: {
      type: 'select',
    },
    options: ['center', 'start'],
  },
  controlAlign: {
    control: {
      type: 'select',
    },
    options: ['center', 'start'],
  },
};
