import cx from 'classnames';
import React, { VFC, useRef } from 'react';

import { BaseRadioProps, useRadio } from '@use-platform/react';

import { CustomizableProps } from '../../libs/css-modules';

import styles from './Radio.module.css';

export interface RadioProps extends CustomizableProps, BaseRadioProps {}

export const Radio: VFC<RadioProps> = (props) => {
  const { className, checked, defaultChecked } = props;
  const inputRef = useRef<HTMLInputElement>(null);
  const { rootProps, inputProps } = useRadio(props, inputRef);
  const isChecked = checked || defaultChecked;

  return (
    <div
      {...rootProps}
      className={cx(
        styles.root,
        {
          [styles.root_isChecked]: isChecked,
        },
        className,
      )}
    >
      <input {...inputProps} className={styles.input} />
    </div>
  );
};
