import React, { ChangeEvent, useCallback, useState } from 'react';

import { Story } from '@storybook/react';

import { Radio } from '../index';

export const Default: Story = () => {
  const [value, setValue] = useState('1');

  const onChange = useCallback((event: ChangeEvent<HTMLInputElement>) => {
    setValue(event.target.value);
  }, []);

  return (
    <>
      <Radio name="radio-60390c" value="1" checked={value === '1'} onChange={onChange} />
      <Radio name="radio-60390c" value="2" checked={value === '2'} onChange={onChange} />
    </>
  );
};
