import { ComponentProps } from 'react';

import { component } from '../../libs/css-modules';
import { Radio as UnstyledRadio } from './Radio';

import sizeM from './_size/size-m.module.css';
import variantAction from './_variant/variant-action.module.css';

export type RadioProps = ComponentProps<typeof Radio>;

export const Radio = component(UnstyledRadio, {
  displayName: 'Radio',
  defaultProps: {
    size: 'm',
    variant: 'action',
  },
  variants: {
    size: {
      m: sizeM.root,
    },
    variant: {
      action: variantAction.root,
    },
  },
});
