import classNames from 'classnames';
import React, { FC } from 'react';

import styles from './TextGroup.module.css';

export interface TextGroupProps {
  text?: string;
  textBold?: boolean;
  label?: string;
  labelBold?: boolean;
}

export const TextGroup: FC<TextGroupProps> = ({ text, label, textBold, labelBold }) => {
  return (
    <div>
      {label && (
        <div className={classNames(styles.text, styles.label)} data-bold={labelBold}>
          {label}
        </div>
      )}
      <p className={styles.text} data-bold={textBold}>
        {text}
      </p>
    </div>
  );
};
