import React from 'react';

import { Story } from '@storybook/react';

import { Shortcut } from '../index';

export const Default: Story = (args: any) => {
  return <Shortcut {...args} />;
};

Default.args = {
  size: 's',
  text: 'Промка фичи или сервиса',
  label: 'Лейбл',
  textBold: true,
};

Default.argTypes = {
  size: {
    control: { type: 'select' },
    options: ['s', 'm', 'l'],
  },
  text: {
    control: { type: 'text' },
  },
  label: {
    control: { type: 'text' },
    defaultValue: '',
  },
  labelBold: {
    control: { type: 'boolean' },
    defaultValue: false,
  },
  textBold: {
    control: { type: 'boolean' },
    defaultValue: false,
  },
};
