import { component } from '../../libs/css-modules';
import { ShortcutComponent } from './Shortcut';

import sizeL from './_size/size-l.module.css';
import sizeM from './_size/size-m.module.css';
import sizeS from './_size/size-s.module.css';
import variantDefault from './_variant/variant-default.module.css';
import variantEdadeal from './_variant/variant-edadeal.module.css';
import variantFamily from './_variant/variant-family.module.css';
import variantPay from './_variant/variant-pay.module.css';
import variantPlus from './_variant/variant-plus.module.css';

export const Shortcut = component(ShortcutComponent, {
  displayName: 'Shortcut',
  defaultProps: {
    variant: 'default',
    size: 's',
  },
  variants: {
    size: {
      s: sizeS.root,
      m: sizeM.root,
      l: sizeL.root,
    },
    variant: {
      default: variantDefault.root,
      plus: variantPlus.root,
      edadeal: variantEdadeal.root,
      family: variantFamily.root,
      pay: variantPay.root,
    },
  },
});

export const variants = ['default', 'plus', 'edadeal', 'family', 'pay'] as const;
