import cx from 'classnames';
import React, { AnimationEvent, HTMLAttributes, forwardRef, useCallback } from 'react';

import styles from './Progress.module.css';

export interface ProgressProps extends HTMLAttributes<HTMLDivElement> {
  duration?: number;
  onClose?: () => void;
}

export const Progress = forwardRef<HTMLDivElement, ProgressProps>((props, ref) => {
  const { className, duration = Infinity, onClose, onAnimationEnd, ...otherProps } = props;

  const handleAnimationEnd = useCallback(
    (event: AnimationEvent<HTMLDivElement>) => {
      if (event.target === event.currentTarget) {
        onClose?.();
      }

      onAnimationEnd?.(event);
    },
    [onClose, onAnimationEnd],
  );

  if (!Number.isFinite(duration)) {
    return null;
  }

  return (
    <div
      ref={ref}
      className={cx(styles.root, className)}
      onAnimationEnd={handleAnimationEnd}
      {...otherProps}
      style={{ animationDuration: `${duration}ms` }}
    />
  );
});
