describe('Snackbar', () => {
  const elements = {
    safeArea: `[data-testid='safe-area']`,
  };

  describe('size', () => {
    ['m', 'l'].forEach((size) => {
      it(size, async function () {
        const { browser } = this;

        await browser.yaOpenStory('snackbar', 'default', {
          args: `before:success;after:icon;size:${size}`,
        });
        await browser.assertView(`size-${size}`, elements.safeArea);
      });
    });
  });

  describe('colorScheme', () => {
    ['light', 'dark'].forEach((colorScheme) => {
      it(colorScheme, async function () {
        const { browser } = this;

        await browser.yaOpenStory('snackbar', 'default', {
          args: `before:success;after:icon;colorScheme:${colorScheme}`,
        });
        await browser.assertView(`color-schema-${colorScheme}`, elements.safeArea);
      });
    });
  });

  describe('width', () => {
    ['auto', 'available'].forEach((width) => {
      it(width, async function () {
        const { browser } = this;

        await browser.yaOpenStory('snackbar', 'default', {
          args: `before:success;after:icon;width:${width}`,
        });
        await browser.assertView(`width-${width}`, elements.safeArea);
      });
    });
  });

  describe('content', () => {
    it('text only', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:none;after:none;children:Text only`,
      });
      await browser.assertView('plain', elements.safeArea);
    });

    it('icon + text', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:success;after:none;children:Text`,
      });
      await browser.assertView('plain', elements.safeArea);
    });

    it('text + icon', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:none;after:icon;children:Text`,
      });
      await browser.assertView('plain', elements.safeArea);
    });

    it('text + button', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:none;after:button;children:Text`,
      });
      await browser.assertView('plain', elements.safeArea);
    });

    it('icon + text + button', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:success;after:button;children:Text`,
      });
      await browser.assertView('plain', elements.safeArea);
    });

    it('icon + text + button + icon', async function () {
      const { browser } = this;

      await browser.yaOpenStory('snackbar', 'default', {
        args: `before:success;after:button-icon;children:Text`,
      });
      await browser.assertView('plain', elements.safeArea);
    });
  });
});
