import React, { SVGAttributes, forwardRef } from 'react';

export interface IconProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const CheckIcon = forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM16.6607 8.25136C16.2451 7.88754 15.6134 7.92946 15.2496 8.34498L10.7332 13.5033L8.73739 11.3245C8.36434 10.9173 7.73178 10.8896 7.32454 11.2626C6.91729 11.6357 6.88957 12.2682 7.26262 12.6755L9.63551 15.2659C10.1951 15.8767 11.1439 15.9183 11.7548 15.3588C11.7847 15.3303 11.7997 15.3161 11.8141 15.3014C11.8285 15.2866 11.8424 15.2713 11.8701 15.2408L16.7543 9.66247C17.1181 9.24695 17.0762 8.61517 16.6607 8.25136Z"
        fill="currentColor"
      />
    </svg>
  );
});

export const CloseIcon = forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.2071 6.20711C19.5976 5.81658 19.5976 5.18342 19.2071 4.79289C18.8166 4.40237 18.1834 4.40237 17.7929 4.79289L12 10.5858L6.20711 4.79289C5.81658 4.40237 5.18342 4.40237 4.79289 4.79289C4.40237 5.18342 4.40237 5.81658 4.79289 6.20711L10.5858 12L4.79289 17.7929C4.40237 18.1834 4.40237 18.8166 4.79289 19.2071C5.18342 19.5976 5.81658 19.5976 6.20711 19.2071L12 13.4142L17.7929 19.2071C18.1834 19.5976 18.8166 19.5976 19.2071 19.2071C19.5976 18.8166 19.5976 18.1834 19.2071 17.7929L13.4142 12L19.2071 6.20711Z"
        fill="currentColor"
      />
    </svg>
  );
});

export const ErrorIcon = forwardRef<SVGSVGElement, IconProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12ZM10.75 16.2428C10.75 15.5202 11.2991 15 11.9928 15C12.7009 15 13.25 15.5202 13.25 16.2428C13.25 16.9653 12.7009 17.5 11.9928 17.5C11.2991 17.5 10.75 16.9653 10.75 16.2428ZM11.3223 6C11.0376 6 10.8103 6.23741 10.8228 6.52185L11.129 13.5219C11.1407 13.7892 11.3609 14 11.6285 14H12.3713C12.639 14 12.8591 13.7892 12.8708 13.5219L13.1771 6.52185C13.1895 6.23741 12.9623 6 12.6776 6H11.3223Z"
        fill="currentColor"
      />
    </svg>
  );
});
