import { ComponentProps } from 'react';

import { component } from '../../libs/css-modules';
import { Snackbar as UnstyledSnackbar } from './Snackbar';

import sizeL from './_size/size-l.module.css';
import sizeM from './_size/size-m.module.css';
import widthAuto from './_width/width-auto.module.css';
import widthAvailable from './_width/width-available.module.css';

const _Snackbar = component(UnstyledSnackbar, {
  displayName: 'Snackbar',
  defaultProps: {
    size: 'm',
    width: 'auto',
  },
  variants: {
    size: {
      m: sizeM.root,
      l: sizeL.root,
    },
    width: {
      auto: widthAuto.root,
      available: widthAvailable.root,
    },
  },
});

export const Snackbar = Object.assign(_Snackbar, {
  Before: UnstyledSnackbar.Before,
  Content: UnstyledSnackbar.Content,
  After: UnstyledSnackbar.After,
  Progress: UnstyledSnackbar.Progress,
});

export type SnackbarProps = ComponentProps<typeof Snackbar>;
