import React, { ChangeEvent, useCallback, useState } from 'react';

import { Story } from '@storybook/react';
import {
  Snackbar,
  SnackbarContainer,
  SnackbarContainerProps,
  SnackbarStore,
  Text,
  TextInput,
} from '@yandex-id/components';
import { Button } from '@yandex-id/components/next';

const store = new SnackbarStore();

function show(text?: string) {
  return store.show((props) => {
    const { id, onClose } = props;

    return (
      <Snackbar onClose={onClose}>
        <Text variant="text-m">{text || 'Yandex ID'}</Text>
        <Text variant="text-m" color="secondary">
          {id}
        </Text>
        <Snackbar.After>
          <Button variant="clear" onPress={onClose}>
            Закрыть
          </Button>
        </Snackbar.After>
      </Snackbar>
    );
  });
}

export const Default: Story<SnackbarContainerProps> = (args) => {
  const [value, setValue] = useState('Yandex ID');

  const handleChange = useCallback((event: ChangeEvent<HTMLInputElement>) => {
    setValue(event.target.value);
  }, []);

  const handleAdd = useCallback(() => {
    show(value);
  }, [value]);

  const handleClear = useCallback(() => {
    store.clear();
  }, []);

  return (
    <>
      <div
        style={{
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          width: '100%',
          height: '90vh',
        }}
      >
        <div style={{ display: 'grid', gap: '16px', gridAutoFlow: 'row', width: '50vw' }}>
          <TextInput
            view="default"
            size="m"
            placeholder="Текст сообщения"
            value={value}
            onChange={handleChange}
          />
          <Button variant="default" size="m" onPress={handleAdd}>
            Добавить
          </Button>

          <Button variant="clear" size="m" onPress={handleClear}>
            Очистить всё
          </Button>
        </div>
      </div>

      <SnackbarContainer {...args} store={store} />
    </>
  );
};

Default.args = {
  position: 'bottom-center',
  maxCount: 1,
  reverseOrder: false,
  gap: 8,
};

Default.argTypes = {
  position: {
    control: {
      type: 'select',
    },
    options: ['top-start', 'top-center', 'top-end', 'bottom-start', 'bottom-center', 'bottom-end'],
  },
  maxCount: {
    control: { type: 'number', min: 1 },
  },
};
