import { ComponentType } from 'react';

export type SnackbarPosition =
  | 'top-center'
  | 'top-start'
  | 'top-end'
  | 'bottom-start'
  | 'bottom-center'
  | 'bottom-end';

export interface SnackbarComponentProps {
  id: string;
  onClose: () => void;
}

export interface SnackbarState {
  id: string;
  visible: boolean;
  visibility: 'hidden' | 'visible';
  component: ComponentType<SnackbarComponentProps>;
}
