import React, { ElementType } from 'react';

import { Story } from '@storybook/react';
import { Text, TextColor, TextVariant, TextWeight } from '@yandex-id/components';

interface DefaultArgs {
  as?: ElementType | 'none';
  variant?: TextVariant | 'none';
  color?: TextColor | 'none';
  weight?: TextWeight | 'none';
  overflow?: 'ellipsis' | 'none';
  maxLines?: number;
  children?: string;
}

export const Default: Story<DefaultArgs> = (args) => {
  const { as, variant, color, weight, overflow, maxLines, children } = args;

  return (
    <div style={{ color: color === 'inherit' ? '#7755FF' : undefined }}>
      <Text
        as={as === 'none' ? undefined : as}
        variant={variant === 'none' ? undefined : variant}
        color={color === 'none' ? undefined : color}
        weight={weight === 'none' ? undefined : weight}
        overflow={overflow === 'none' ? undefined : overflow}
        maxLines={maxLines}
        data-testid="element"
      >
        {children}
      </Text>
    </div>
  );
};

Default.args = {
  as: 'span',
  children: 'Миссия Яндекса — помогать людям решать задачи и достигать своих целей в жизни.',
  variant: 'text-m',
  color: 'primary',
};

const variants: TextVariant[] = [
  'display-l',
  'display-m',
  'display-s',
  'heading-xl',
  'heading-l',
  'heading-m',
  'heading-s',
  'text-l',
  'text-l-long',
  'text-m',
  'text-m-long',
  'text-s',
  'text-s-long',
  'text-xs',
  'text-xs-long',
  'text-xxs',
];

const colors: TextColor[] = ['inherit', 'primary', 'secondary', 'tertiary', 'positive', 'negative'];

Default.argTypes = {
  as: {
    control: { type: 'select' },
    options: ['none', 'h1', 'h2', 'h3', 'h4', 'span', 'p', 'div'],
  },
  variant: {
    control: { type: 'select' },
    options: ['none', ...variants],
  },
  color: {
    control: { type: 'select' },
    options: ['none', ...colors],
  },
  weight: {
    control: { type: 'select' },
    options: ['none', 'regular', 'medium', 'bold'],
  },
  overflow: {
    control: { type: 'select' },
    options: ['none', 'ellipsis'],
  },
  maxLines: {
    control: { type: 'number', min: 1 },
  },
};
