describe('TextInput', function () {
  const elements = {
    story: '[data-testid=input-story]',
    input: '[data-testid=input]',
  };

  describe('Default', function () {
    it('hint', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default', {
        args: 'size:m;hint:Some important information',
      });
      await browser.assertView('default-hint', elements.story);
    });

    it('error', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default', {
        args: 'size:m;hint:Something went wrong;state:error',
      });
      await browser.assertView('default-error', elements.story);
    });

    it('hover', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default');
      const input = await browser.$(elements.input);

      await input.moveTo();

      await browser.assertView('default-hint', elements.story);
    });

    it('focus', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default');
      const input = await browser.$(elements.input);

      await input.click();
      await input.moveTo({ xOffset: -10, yOffset: -10 });

      await browser.assertView('default-focus', elements.story);
    });

    it('has value', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default');
      const input = await browser.$(elements.input);

      await input.click();
      await input.moveTo({ xOffset: -10, yOffset: -10 });
      await browser.keys('Hello world'.split(''));

      await browser.assertView('default-has-value', elements.story);
    });

    it('disabled', async function () {
      const { browser } = this;

      await browser.yaOpenStory('textinput', 'default', { args: 'size:m;disabled:true' });
      await browser.assertView('default-disabled', elements.story);
    });

    ['s', 'm', 'l', 'xl', 'xxl'].forEach((size) => {
      it(`size ${size}`, async function () {
        const { browser } = this;

        await browser.yaOpenStory('textinput', 'default', { args: `size:${size}` });
        await browser.assertView(`default-size-${size}`, elements.story);
      });
    });
  });

  ['left', 'right', 'both'].forEach((iconPosition) => {
    describe(`Icon ${iconPosition}`, function () {
      ['s', 'm', 'l', 'xl', 'xxl'].forEach((size) => {
        it(`size ${size}`, async function () {
          const { browser } = this;

          await browser.yaOpenStory('textinput', `icon-${iconPosition}`, { args: `size:${size}` });
          await browser.assertView(`icon-${iconPosition}-size-${size}`, elements.story);
        });
      });
    });
  });
});
