import { ComponentProps } from 'react';

import { compose, composeU } from '@bem-react/core';
import {
  Textinput as LegoTextInput,
  withSizeM,
  withSizeS,
  withViewDefault,
} from '@yandex-lego/components/Textinput/desktop';

import { withMask } from './_mask/Input_mix_mask';
import { withSizeL } from './_size/Textinput_size_l';
import { withSizeXl } from './_size/Textinput_size_xl';
import { withSizeXxl } from './_size/Textinput_size_xxl';

import './TextInput.css';

export type TextInputProps = ComponentProps<typeof TextInput>;

export const TextInput = compose(
  composeU(withSizeS, withSizeM, withSizeL, withSizeXl, withSizeXxl),
  composeU(withViewDefault),
  withMask,
)(LegoTextInput);
