import React from 'react';

import { Story } from '@storybook/react';

import { TextInput } from '../TextInput';

interface Args {
  size: 's' | 'm' | 'l' | 'xl' | 'xxl';
  placeholder: string;
  disabled: boolean;
  hint: string;
  state?: 'error';
}

export const Default: Story<Args> = (args) => {
  return (
    <div data-testid="input-story">
      <TextInput {...args} view="default" data-testid="input" />
    </div>
  );
};

Default.argTypes = {
  size: {
    control: {
      type: 'select',
    },
    options: ['s', 'm', 'l', 'xl', 'xxl'],
  },
  state: {
    control: {
      type: 'select',
    },
    options: ['error'],
  },
};

Default.args = {
  size: 'm',
  placeholder: 'Placeholder',
  disabled: false,
  hint: '',
};
