import React from 'react';

import { Story } from '@storybook/react';
import { Icon } from '@yandex-lego/components/Icon/bundle';

import { TextInput } from '../TextInput';

interface Args {
  size: 's' | 'm' | 'l' | 'xl' | 'xxl';
  placeholder: string;
  disabled: boolean;
  hint: string;
}

export const IconBoth: Story<Args> = (args) => {
  const icon = <Icon glyph="type-filter" />;

  return (
    <div data-testid="input-story">
      <TextInput {...args} view="default" iconRight={icon} iconLeft={icon} />
    </div>
  );
};

IconBoth.argTypes = {
  size: {
    control: {
      type: 'select',
    },
    options: ['s', 'm', 'l', 'xl', 'xxl'],
  },
};

IconBoth.args = {
  size: 'm',
  placeholder: 'Placeholder',
  disabled: false,
  hint: '',
};
