import React from 'react';

import { Story } from '@storybook/react';
import { Icon } from '@yandex-lego/components/Icon/bundle';

import { TextInput } from '../TextInput';

interface Args {
  size: 's' | 'm' | 'l' | 'xl' | 'xxl';
  placeholder: string;
  disabled: boolean;
  hint: string;
}

export const IconLeft: Story<Args> = (args) => {
  return (
    <div data-testid="input-story">
      <TextInput {...args} view="default" iconLeft={<Icon glyph="type-filter" />} />
    </div>
  );
};

IconLeft.argTypes = {
  size: {
    control: {
      type: 'select',
    },
    options: ['s', 'm', 'l', 'xl', 'xxl'],
  },
};

IconLeft.args = {
  size: 'm',
  placeholder: 'Placeholder',
  disabled: false,
  hint: '',
};
