import { createClassNameModifier } from '@bem-react/core';
import { cnTextinput } from '@yandex-lego/components/Textinput/desktop';

import './Textinput_size_l.css';

export interface TextinputSizeLProps {
  /**
   * Размер текстового поля.
   */
  size?: 'l';
}

/**
 * Модификатор, отвечающий за размер текстового поля.
 * @param {TextinputSizeLProps} props
 */
export const withSizeL = createClassNameModifier<TextinputSizeLProps>(cnTextinput(), { size: 'l' });
