import { createClassNameModifier } from '@bem-react/core';
import { cnTextinput } from '@yandex-lego/components/Textinput/desktop';

import './Textinput_size_xl.css';

export interface TextinputSizeXlProps {
  /**
   * Размер текстового поля.
   */
  size?: 'xl';
}

/**
 * Модификатор, отвечающий за размер текстового поля.
 * @param {TextinputSizeXlProps} props
 */
export const withSizeXl = createClassNameModifier<TextinputSizeXlProps>(cnTextinput(), {
  size: 'xl',
});
