import { createClassNameModifier } from '@bem-react/core';
import { cnTextinput } from '@yandex-lego/components/Textinput/desktop';

import './Textinput_size_xxl.css';

export interface TextinputSizeXxlProps {
  /**
   * Размер текстового поля.
   */
  size?: 'xxl';
}

/**
 * Модификатор, отвечающий за размер текстового поля.
 * @param {TextinputSizeXxlProps} props
 */
export const withSizeXxl = createClassNameModifier<TextinputSizeXxlProps>(cnTextinput(), {
  size: 'xxl',
});
