import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import './AppStore.css';

export interface IAppStoreProps extends IClassNameProps {
  lang: string;
}

export const cnAppStore = cn('AppStore');

export const AppStore: React.FC<IAppStoreProps> = ({ className, lang }) => (
  <div className={cnAppStore({ lang }, [className])} />
);
