import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import './GooglePlay.css';

export interface IGooglePlayProps extends IClassNameProps {
  lang: string;
}

export const cnGooglePlay = cn('GooglePlay');

export const GooglePlay: React.FC<IGooglePlayProps> = ({ className, lang }) => (
  <div className={cnGooglePlay({ lang }, [className])} />
);
