import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import './PhonePromo.css';

export interface IPhonePromoProps extends IClassNameProps {
  full?: boolean;
}

export const cnPhonePromo = cn('PhonePromo');

export const PhonePromo: React.FC<IPhonePromoProps> = ({ className, full }) => (
  <div className={cnPhonePromo({ full }, [className])} />
);
