import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import './Ya.css';

export interface IYaProps extends IClassNameProps {
  lang?: string;
}

export const cnYa = cn('Ya');

export const Ya: React.FC<IYaProps> = ({ className, lang = 'ru' }) => {
  const isRu = ['ru', 'uk'].includes(lang);

  return <div className={cnYa({ isRu }, [className])} />;
};
