import React from 'react';

import { Meta, Story } from '@storybook/react';

import { IYandexAppPromoProps, YandexAppPromo } from '.';

export default {
  id: 'YandexAppPromo',
  title: 'Components/YandexAppPromo',
  component: YandexAppPromo,
  args: {
    title: 'Заголовок промки',
    description: 'Описание промки',
  },
  argTypes: {
    lang: {
      control: {
        type: 'select',
        options: ['ru', 'ua', 'kz', 'by', 'en', 'tr', 'whatever'],
      },
      defaultValue: 'ru',
    },
  },
} as Meta;

const Template: Story<IYandexAppPromoProps> = (args) => (
  <YandexAppPromo {...args}>
    <div className="YandexAppPromoStories">Контент страницы</div>
  </YandexAppPromo>
);

export const Default = Template.bind({});
