import type { StylesChunk } from '../types';

export function mergeStyles(
  prev: StylesChunk[] = [],
  next: StylesChunk | StylesChunk[] = [],
): StylesChunk[] {
  // eslint-disable-next-line no-param-reassign
  next = Array.isArray(next) ? next : [next];

  if (prev.length === 0) return next;
  if (next.length === 0) return prev;

  return prev.concat(next);
}
