import type { Variants } from '../types';

export function mergeVariants(prev: Variants = {}, next: Variants = {}): Variants {
  const variants: Variants = {};
  const keys = ([] as string[]).concat(Object.keys(prev), Object.keys(next));

  for (const key of keys) {
    variants[key] = {};

    if (prev[key]) {
      typeof prev[key] === 'object'
        ? Object.assign(variants[key], prev[key])
        : (variants[key] = prev[key]);
    }
    if (next[key]) {
      typeof next[key] === 'object'
        ? Object.assign(variants[key], next[key])
        : (variants[key] = next[key]);
    }
  }

  return variants;
}
