import { useContext, useEffect, useState } from 'react';

import { FeatureFlagsContext } from './context';
import { QueryParams, getQueryParams } from './utils';

/**
 * Returns feature flags from query params.
 *
 * @example
 * const features = useQueryFeatureFlags()
 * features.isEndabled('suggest') // true or false
 */
export function useQueryFeatureFlags() {
  const [params, setParams] = useState<QueryParams>({});
  const contextParams = useContext(FeatureFlagsContext);

  useEffect(() => {
    const queryParams = getQueryParams(window.location.search);

    setParams({ ...contextParams, ...queryParams });
  }, []);

  function isEnabled(feature: string) {
    return params[feature] === '1';
  }

  return {
    isEnabled,
  };
}
