export type QueryParams = Record<string, string>;

/**
 * Returns map with features flags and values.
 *
 * @example
 * const params = getQueryParams('?feature=first-feature=1&feature=second-feature=1')
 * params['first-feature'] // -> 1
 * params['second-feature'] // -> 1
 */
export function getQueryParams(query: string): QueryParams {
  const FEATURE_RE = /^feature=/;

  const chunks = decodeURIComponent(query).slice(1).split('&');
  const params: QueryParams = {};

  for (const chunk of chunks) {
    if (chunk.match(FEATURE_RE) !== null) {
      const [feature, value] = chunk.replace(FEATURE_RE, '').split('=');

      params[feature] = value;
    }
  }

  return params;
}
