import { useMemo } from 'react';

import { useLocale } from '@use-platform/react';

const formatterCache = new Map<string, Intl.NumberFormat>();

// TODO: Move to @use-platform/react
export function useNumberFormatter(options?: Intl.NumberFormatOptions): Intl.NumberFormat {
  const { locale } = useLocale();

  const cacheKey = useMemo(() => getCacheKey(locale, options), [locale, options]);
  const cacheValue = formatterCache.get(cacheKey);

  if (cacheValue) {
    return cacheValue;
  }

  const formatter = new Intl.NumberFormat(locale, options);

  formatterCache.set(cacheKey, formatter);

  return formatter;
}

function getCacheKey(locale: string, options?: Intl.NumberFormatOptions): string {
  let salt = '';

  if (options !== undefined) {
    salt = Object.keys(options)
      .map((key) => [key, options[key as keyof Intl.NumberFormatOptions]] as const)
      .sort((a, b) => (a[0] < b[0] ? -1 : 1))
      .join();
  }

  return locale + salt;
}
